<?php
// Template: Business - Refaktorirano sa accent color sistemom
?>
<!DOCTYPE html>
<html lang="hr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?></title>
  <link rel="icon" type="image/png" href="/favicon.png">
<link rel="apple-touch-icon" href="/favicon.png">
<meta name="robots" content="noindex, nofollow">
<meta property="og:image" content="https://card.taptap.ba/og-image.jpg">
<meta property="og:title" content="<?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($user['opis'] ?? 'Digitalna vizitka'); ?>">
<meta property="og:url" content="https://card.taptap.ba/<?php echo $user['slug']; ?>">
<!-- Open Graph -->
  <meta property="og:type" content="website">
  <meta property="og:title" content="<?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?>">
  <meta property="og:description" content="<?php echo htmlspecialchars($user['opis'] ?? 'Digitalna vizitka'); ?>">
  <meta property="og:image" content="https://card.taptap.ba/og-image.jpg">
  <meta property="og:image:type" content="image/jpeg">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:url" content="https://card.taptap.ba/<?php echo urlencode($user['slug']); ?>">
  <style>
    :root {
      --accent: <?php echo htmlspecialchars($user['accent_color'] ?? '#3b82f6'); ?>;
      --accent-light: <?php echo htmlspecialchars($user['accent_color'] ?? '#3b82f6'); ?>22;
      --accent-hover: <?php echo htmlspecialchars($user['accent_color'] ?? '#3b82f6'); ?>dd;
    }
    
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Inter', Roboto, sans-serif;
      background: #f3f4f6;
      min-height: 100vh;
      padding-bottom: 70px;
    }
    
    .container {
      max-width: 480px;
      margin: 0 auto;
      background: white;
      min-height: 100vh;
      box-shadow: 0 0 50px rgba(0,0,0,0.08);
    }
    
    .header {
      background: #1e293b;
      padding: 50px 30px 40px;
      text-align: center;
      position: relative;
      overflow: hidden;
      <?php if ($user['background_image']): ?>
      background-image: url('<?php echo htmlspecialchars($user['background_image']); ?>');
      background-size: cover;
      background-position: center;
      <?php endif; ?>
    }
    
    .header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(30, 41, 59, 0.85);
      z-index: 0;
    }
    
    /*.header::after {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 100%;
      background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><defs><pattern id="grid" width="20" height="20" patternUnits="userSpaceOnUse"><path d="M 20 0 L 0 0 0 20" fill="none" stroke="rgba(255,255,255,0.03)" stroke-width="1"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
      z-index: 1;
    }*/
    
    .profile-image {
      width: 110px;
      height: 110px;
      border-radius: 50%;
      border: 4px solid white;
      object-fit: cover;
      margin: 0 auto 20px;
      box-shadow: 0 8px 24px rgba(0,0,0,0.3);
      position: relative;
      z-index: 2;
    }
    
    .profile-placeholder {
      width: 110px;
      height: 110px;
      border-radius: 50%;
      background: var(--accent-light);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 42px;
      margin: 0 auto 20px;
      border: 4px solid white;
      font-weight: 700;
      color: var(--accent);
      position: relative;
      z-index: 2;
    }
    
    .name {
      font-size: 26px;
      font-weight: 700;
      color: white;
      margin-bottom: 8px;
      position: relative;
      z-index: 2;
    }
    
    .description {
      font-size: 15px;
      color: rgba(255,255,255,0.9);
      line-height: 1.6;
      max-width: 400px;
      margin: 0 auto;
      position: relative;
      z-index: 2;
    }
    
    .content {
      padding: 30px 20px 20px;
    }
    
    .section {
      margin-bottom: 28px;
    }
    
    .section-title {
      font-size: 13px;
      font-weight: 700;
      color: #64748b;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      margin-bottom: 14px;
      padding-left: 2px;
    }
    
    .contact-grid {
      display: grid;
      gap: 10px;
    }
    
    .contact-item {
      display: flex;
      align-items: center;
      gap: 14px;
      padding: 14px;
      background: white;
      border: 1.5px solid #e5e7eb;
      border-radius: 10px;
      text-decoration: none;
      color: #1e293b;
      transition: all 0.2s ease;
    }
    
    .contact-item:hover {
      border-color: var(--accent);
      background: var(--accent-light);
      transform: translateX(3px);
    }
    
    .contact-icon {
      width: 38px;
      height: 38px;
      min-width: 38px;
      background: var(--accent-light);
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .contact-icon svg {
      width: 19px;
      height: 19px;
      fill: var(--accent);
    }
    
    .contact-info {
      flex: 1;
    }
    
    .contact-label {
      font-size: 11px;
      color: #64748b;
      margin-bottom: 2px;
      text-transform: uppercase;
      letter-spacing: 0.3px;
      font-weight: 600;
    }
    
    .contact-value {
      font-size: 15px;
      font-weight: 500;
      color: #1e293b;
    }
    
    .social-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(90px, 1fr));
      gap: 10px;
    }
    
    .social-link {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      gap: 8px;
      padding: 14px;
      background: white;
      border: 1.5px solid #e5e7eb;
      border-radius: 10px;
      text-decoration: none;
      transition: all 0.2s ease;
    }
    
    .social-link:hover {
      border-color: var(--accent);
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }
    
    .social-icon {
      width: 26px;
      height: 26px;
    }
    
    .social-name {
      font-size: 10px;
      font-weight: 600;
      color: #64748b;
      text-transform: uppercase;
      letter-spacing: 0.3px;
    }
    
    .location-card {
      background: white;
      border: 1.5px solid #e5e7eb;
      border-radius: 10px;
      overflow: hidden;
    }
    
    .location-info {
      display: flex;
      gap: 14px;
      padding: 16px;
    }
    
    .location-icon {
      width: 38px;
      height: 38px;
      min-width: 38px;
      background: var(--accent-light);
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    .location-icon svg {
      width: 19px;
      height: 19px;
      fill: var(--accent);
    }
    
    .location-text {
      flex: 1;
      font-size: 14px;
      line-height: 1.5;
      color: #475569;
    }
    
    .map-container {
      height: 200px;
      border-top: 1.5px solid #e5e7eb;
    }
    
    .instagram-card {
      padding: 18px;
      background: var(--accent);
      border-radius: 10px;
      text-align: center;
    }
    
    .instagram-card h3 {
      color: white;
      font-size: 15px;
      margin-bottom: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 8px;
    }
    
    .instagram-btn {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      padding: 11px 22px;
      background: white;
      color: var(--accent);
      border-radius: 8px;
      text-decoration: none;
      font-weight: 600;
      font-size: 13px;
      transition: all 0.2s;
    }
    
    .instagram-btn:hover {
      transform: scale(1.05);
      box-shadow: 0 4px 16px rgba(0,0,0,0.2);
    }
    
    .branding {
      text-align: center;
      padding: 16px;
      font-size: 11px;
      color: #94a3b8;
      line-height: 1.5;
      border-top: 1px solid #e5e7eb;
    }
    
    .branding a {
      color: var(--accent);
      text-decoration: none;
      font-weight: 600;
    }
    
    .footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      border-top: 1px solid #e5e7eb;
      padding: 0;
      box-shadow: 0 -4px 12px rgba(0,0,0,0.05);
      z-index: 100;
    }
    
    .save-contact-btn {
      width: 100%;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      padding: 16px;
      background: var(--accent);
      color: white;
      border: none;
      border-radius: 0;
      font-size: 15px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.2s;
    }
    
    .save-contact-btn:hover {
      background: var(--accent-hover);
    }
    
    .save-contact-btn:active {
      transform: scale(0.98);
    }
    
    .save-contact-btn svg {
      width: 20px;
      height: 20px;
    }
    
    @media (max-width: 480px) {
      .header { padding: 40px 20px 30px; }
      .content { padding: 25px 16px 16px; }
      .name { font-size: 24px; }
      .social-grid { grid-template-columns: repeat(3, 1fr); }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <?php if ($user['slika']): ?>
        <img src="<?php echo htmlspecialchars($user['slika']); ?>" alt="<?php echo htmlspecialchars($user['ime']); ?>" class="profile-image">
      <?php else: ?>
        <div class="profile-placeholder">
          <?php echo mb_strtoupper(mb_substr($user['ime'], 0, 1) . mb_substr($user['prezime'], 0, 1)); ?>
        </div>
      <?php endif; ?>
      
      <h1 class="name"><?php echo htmlspecialchars($user['ime'] . ' ' . $user['prezime']); ?></h1>
      <?php if ($user['opis']): ?>
        <p class="description"><?php echo nl2br(htmlspecialchars($user['opis'])); ?></p>
      <?php endif; ?>
    </div>
    
    <div class="content">
  <!-- Kontakt -->
  <?php if ($user['telefon'] || $user['email'] || $user['whatsapp'] || $user['viber']): ?>
    <div class="section">
      <h2 class="section-title">Kontakt</h2>
      <div class="contact-grid">
        <?php if ($user['telefon']): ?>
          <a href="tel:<?php echo htmlspecialchars($user['telefon']); ?>" class="contact-item">
            <div class="contact-icon">
              <svg viewBox="0 0 24 24">
                <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56a.977.977 0 00-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
              </svg>
            </div>
            <div class="contact-info">
              <div class="contact-label">Telefon</div>
              <div class="contact-value"><?php echo htmlspecialchars($user['telefon']); ?></div>
            </div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['email']): ?>
          <a href="mailto:<?php echo htmlspecialchars($user['email']); ?>" class="contact-item">
            <div class="contact-icon">
              <svg viewBox="0 0 24 24">
                <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
              </svg>
            </div>
            <div class="contact-info">
              <div class="contact-label">Email</div>
              <div class="contact-value" style="word-break: break-all;"><?php echo htmlspecialchars($user['email']); ?></div>
            </div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['whatsapp']): ?>
          <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $user['whatsapp']); ?>" class="contact-item" target="_blank">
            <div class="contact-icon">
              <svg viewBox="0 0 24 24">
                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
              </svg>
            </div>
            <div class="contact-info">
              <div class="contact-label">WhatsApp</div>
              <div class="contact-value">Pošalji poruku</div>
            </div>
          </a>
        <?php endif; ?>
        
        <?php if ($user['viber']): ?>
          <a href="viber://chat?number=<?php echo preg_replace('/[^0-9+]/', '', $user['viber']); ?>" class="contact-item">
            <div class="contact-icon">
              <svg viewBox="0 0 24 24">
                <path d="M11.4 0C9.473.028 5.333.344 3.02 2.467 1.302 4.187.696 6.7.633 9.817.57 12.933.488 18.776 6.12 20.36h.003l-.004 2.644s-.037.977.61 1.177c.777.242 1.234-.5 1.98-1.302.407-.44.97-1.084 1.396-1.58 3.85.323 6.812-.417 7.15-.525.776-.253 5.176-.816 5.892-6.657.74-6.02-.36-9.83-2.34-11.546 0 0-1.915-2.5-7.398-2.388zM11.45 1.62c4.817-.095 6.545 1.857 6.545 1.857 1.725 1.494 2.674 4.8 2.003 10.158-.629 5.023-4.477 5.383-5.14 5.604-.297.098-2.697.732-6.123.498 0 0-2.427 2.93-3.19 3.698-.12.12-.26.167-.352.145-.13-.03-.166-.18-.165-.396l.02-4.426c-4.71-1.31-4.418-6.27-4.363-8.9.053-2.61.567-4.733 1.99-6.28C4.724 1.646 8.28 1.668 11.45 1.62z"/>
              </svg>
            </div>
            <div class="contact-info">
              <div class="contact-label">Viber</div>
              <div class="contact-value">Pošalji poruku</div>
            </div>
          </a>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>
  
  <!-- Društvene mreže -->
  <?php if (count($links) > 0): ?>
    <div class="section">
      <h2 class="section-title">Društvene mreže</h2>
      <div class="social-grid">
        <?php 
        $socialIcons = [
          'facebook' => '<svg fill="#1877f2" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>',
          'instagram' => '<svg fill="#E1306C" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>',
          'linkedin' => '<svg fill="#0077b5" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452z"/></svg>',
          'x' => '<svg fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>',
          'youtube' => '<svg fill="currentColor" viewBox="0 0 24 24"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814z"/></svg>',
          'website' => '<svg fill="#6366f1" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/></svg>',
          'tiktok' => '<svg fill="#000000" viewBox="0 0 24 24"><path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/></svg>',
          'custom' => '<svg fill="currentColor" viewBox="0 0 24 24"><path d="M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1zM8 13h8v-2H8v2zm9-6h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1h-4V17h4c2.76 0 5-2.24 5-5s-2.24-5-5-5z"/></svg>'
        ];
        
        $socialNames = [
          'facebook' => 'Facebook',
          'instagram' => 'Instagram',
          'linkedin' => 'LinkedIn',
          'x' => 'X',
          'youtube' => 'YouTube',
          'website' => 'Web',
          'tiktok' => 'TikTok',
          'custom' => 'Link'
        ];
        
        foreach ($links as $link):
        ?>
          <a href="<?php echo htmlspecialchars($link['url']); ?>" target="_blank" class="social-link">
            <div class="social-icon">
              <?php echo $socialIcons[$link['tip']] ?? $socialIcons['custom']; ?>
            </div>
            <span class="social-name"><?php echo $socialNames[$link['tip']] ?? 'Link'; ?></span>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>
  
  <!-- Lokacija -->
  <?php if ($user['adresa'] || $user['grad'] || $user['drzava'] || isset($activeModules['mapa'])): ?>
    <div class="section">
      <h2 class="section-title">Lokacija</h2>
      <div class="location-card">
        <?php if ($user['adresa'] || $user['grad'] || $user['drzava']): ?>
        <div class="location-info">
          <div class="location-icon">
            <svg viewBox="0 0 24 24">
              <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
            </svg>
          </div>
          <div class="location-text">
            <?php 
            $addressParts = array_filter([
              $user['adresa'],
              ($user['grad'] && $user['drzava']) ? $user['grad'] . ', ' . $user['drzava'] : ($user['grad'] ?: $user['drzava'])
            ]);
            echo implode('<br>', array_map('htmlspecialchars', $addressParts));
            ?>
          </div>
        </div>
        <?php endif; ?>
        
        <?php if (isset($activeModules['mapa']) && $activeModules['mapa']['config']): ?>
          <?php 
          $mapConfig = json_decode($activeModules['mapa']['config'], true);
          $mapLink = $mapConfig['link'] ?? '';
          if ($mapLink):
          ?>
            <div class="map-container">
              <iframe src="https://maps.google.com/maps?q=<?php echo urlencode($mapLink); ?>&output=embed" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
          <?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>
  
  <!-- Radno vrijeme -->
  <?php if (isset($activeModules['working_hours']) && $activeModules['working_hours']['config']): ?>
    <?php $whConfig = json_decode($activeModules['working_hours']['config'], true); ?>
    <?php if (!empty($whConfig['type'])): ?>
      <div class="section">
        <h2 class="section-title">Radno vrijeme</h2>
        <div style="background: white; border: 1.5px solid #e5e7eb; border-radius: 10px; padding: 20px;">
          <?php if ($whConfig['type'] === 'all_days'): ?>
            <div style="text-align: center;">
              <div style="font-size: 13px; color: #64748b; margin-bottom: 8px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px;">
                Svaki dan
              </div>
              <div style="font-size: 18px; color: #1e293b; font-weight: 600;">
                <?php echo htmlspecialchars($whConfig['all'] ?? ''); ?>
              </div>
            </div>
          <?php else: ?>
            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; text-align: center;">
              <div>
                <div style="font-size: 11px; color: #64748b; margin-bottom: 6px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.3px;">
                  Pon - Pet
                </div>
                <div style="font-size: 15px; color: #1e293b; font-weight: 600;">
                  <?php echo nl2br(htmlspecialchars($whConfig['weekday'] ?? '')); ?>
                </div>
              </div>
              <div>
                <div style="font-size: 11px; color: #64748b; margin-bottom: 6px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.3px;">
                  Subota
                </div>
                <div style="font-size: 15px; color: #1e293b; font-weight: 600;">
                  <?php echo nl2br(htmlspecialchars($whConfig['saturday'] ?? '')); ?>
                </div>
              </div>
              <div>
                <div style="font-size: 11px; color: #64748b; margin-bottom: 6px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.3px;">
                  Nedjelja
                </div>
                <div style="font-size: 15px; color: #1e293b; font-weight: 600;">
                  <?php echo nl2br(htmlspecialchars($whConfig['sunday'] ?? '')); ?>
                </div>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
  
  <!-- Google Reviews -->
  <?php if (isset($activeModules['google_reviews']) && $activeModules['google_reviews']['config']): ?>
    <?php $reviewsConfig = json_decode($activeModules['google_reviews']['config'], true); ?>
    <?php if (!empty($reviewsConfig['link'])): ?>
      <div class="section">
        <a href="<?php echo htmlspecialchars($reviewsConfig['link']); ?>" target="_blank" 
           style="display: flex; align-items: center; justify-content: center; gap: 12px; padding: 18px; background: var(--accent); color: white; border-radius: 10px; text-decoration: none; font-weight: 600; transition: all 0.2s; font-size: 15px;">
          <svg width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"/>
          </svg>
          Ocijenite nas na Googleu
        </a>
      </div>
    <?php endif; ?>
  <?php endif; ?>
  
  <!-- Instagram -->
  <?php if (isset($activeModules['instagram_feed']) && $activeModules['instagram_feed']['config']): ?>
    <?php $igConfig = json_decode($activeModules['instagram_feed']['config'], true); ?>
    <div class="section">
      <div class="instagram-card">
        <h3 style="margin-bottom: 15px;">Pratite nas na Instagramu</h3>
        <a href="https://instagram.com/<?php echo htmlspecialchars($igConfig['username']); ?>" target="_blank" class="instagram-btn">
          @<?php echo htmlspecialchars($igConfig['username']); ?>
        </a>
      </div>
    </div>
  <?php endif; ?>
  
  <!-- Text Block -->
  <?php if (isset($activeModules['text_block']) && $activeModules['text_block']['config']): ?>
    <?php $textConfig = json_decode($activeModules['text_block']['config'], true); ?>
    <?php if (!empty($textConfig['content'])): ?>
      <div class="section">
        <div style="background: white; border: 1.5px solid #e5e7eb; border-radius: 10px; padding: 20px;">
          <div style="font-size: 14px; line-height: 1.7; color: #334155; white-space: pre-wrap;">
            <?php echo nl2br(htmlspecialchars($textConfig['content'])); ?>
          </div>
        </div>
      </div>
    <?php endif; ?>
  <?php endif; ?>
  
  <!-- Branding -->
  <div class="branding">
    Made with <a href="https://taptap.ba" target="_blank">TapTap</a> • Powered by <a href="https://convoco.co" target="_blank">Convoco</a>
  </div>
</div>
  
<?php if (isset($activeModules['vcard']) || isset($activeModules['qr_code'])): ?>
  <div class="footer">
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 0;">
      <?php if (isset($activeModules['vcard'])): ?>
        <button class="footer-btn" onclick="downloadVCard()" style="border-right: 1px solid rgba(255,255,255,0.2);">
          <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"/>
          </svg>
          Spremi kontakt
        </button>
      <?php endif; ?>
      
      <?php if (isset($activeModules['qr_code'])): ?>
        <button class="footer-btn" onclick="toggleQR()">
          <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h4M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"/>
          </svg>
          Prikaži QR kod
        </button>
      <?php endif; ?>
    </div>
  </div>

  <!-- QR Code Modal -->
  <?php if (isset($activeModules['qr_code'])): ?>
    <div id="qrModal" class="qr-modal" onclick="toggleQR()">
      <div class="qr-modal-content" onclick="event.stopPropagation()">
        <button class="qr-close" onclick="toggleQR()">×</button>
        <h3 style="text-align: center; margin-bottom: 20px; color: #333;">Skeniraj QR kod</h3>
        <div style="text-align: center; padding: 20px; background: white; border-radius: 12px;">
          <img src="https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . '/' . $user['slug'] . '?qr=1'); ?>" 
               alt="QR Code" 
               style="max-width: 100%; height: auto; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
        </div>
        <p style="text-align: center; margin-top: 15px; color: #666; font-size: 14px;">
          Skeniraj ovaj kod da spremiš kontakt
        </p>
      </div>
    </div>
  <?php endif; ?>
<?php endif; ?>

<style>
.social-icon svg {
  color: var(--accent);
}
.footer {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  background: white;
  border-top: 1px solid #e5e7eb;
  box-shadow: 0 -4px 12px rgba(0,0,0,0.05);
  z-index: 100;
}

.footer-btn {
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 10px;
  padding: 16px;
  background: var(--accent, #667eea);
  color: white;
  border: none;
  font-size: 15px;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.2s;
}

.footer-btn:hover {
  background: var(--accent-hover, #5568d3);
}

.footer-btn:active {
  transform: scale(0.98);
}

.footer-btn svg {
  width: 20px;
  height: 20px;
}

.qr-modal {
  display: none;
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.7);
  z-index: 1000;
  align-items: center;
  justify-content: center;
  padding: 20px;
}

.qr-modal.active {
  display: flex;
}

.qr-modal-content {
  background: #f8f9fa;
  padding: 30px;
  border-radius: 20px;
  max-width: 400px;
  width: 100%;
  position: relative;
  box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.qr-close {
  position: absolute;
  top: 15px;
  right: 15px;
  background: rgba(0, 0, 0, 0.1);
  border: none;
  width: 35px;
  height: 35px;
  border-radius: 50%;
  font-size: 24px;
  cursor: pointer;
  color: #333;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s;
}

.qr-close:hover {
  background: rgba(0, 0, 0, 0.2);
  transform: rotate(90deg);
}

/* Dodaj padding-bottom na body da footer ne prekrije sadržaj */
body {
  padding-bottom: 70px;
}

@media (max-width: 480px) {
  .footer-btn {
    font-size: 13px;
    padding: 14px;
  }
  .qr-modal-content {
    padding: 25px;
  }
}
</style>

<script>
function toggleQR() {
  const modal = document.getElementById('qrModal');
  modal.classList.toggle('active');
}

function downloadVCard() {
  // Jednostavno otvori PHP endpoint koji će servirati vCard
  window.location.href = '/vcard.php?slug=<?php echo urlencode($user['slug']); ?>';
}
</script>
<!-- DODAJ OVO U template-business.php PRIJE closing </body> taga -->

<!-- Kontakt forma modal -->
<div id="contactModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.7); z-index:9999; justify-content:center; align-items:center;">
    <div style="background:white; padding:30px; border-radius:12px; max-width:500px; width:90%; max-height:90vh; overflow-y:auto;">
        <h3 style="margin-bottom:20px; color:#333;">Pošalji poruku</h3>
        <form id="contactForm">
            <div style="margin-bottom:15px;">
                <label style="display:block; margin-bottom:5px; color:#555; font-weight:500;">Vaše ime *</label>
                <input type="text" id="senderName" required style="width:100%; padding:10px; border:2px solid #e0e0e0; border-radius:6px;">
            </div>
            <div style="margin-bottom:15px;">
                <label style="display:block; margin-bottom:5px; color:#555; font-weight:500;">Vaš email *</label>
                <input type="email" id="senderEmail" required style="width:100%; padding:10px; border:2px solid #e0e0e0; border-radius:6px;">
            </div>
            <div style="margin-bottom:15px;">
                <label style="display:block; margin-bottom:5px; color:#555; font-weight:500;">Poruka *</label>
                <textarea id="senderMessage" required style="width:100%; padding:10px; border:2px solid #e0e0e0; border-radius:6px; min-height:120px; resize:vertical;"></textarea>
            </div>
            <div style="display:flex; gap:10px;">
                <button type="submit" style="flex:1; padding:12px; background:#3b82f6; color:white; border:none; border-radius:6px; cursor:pointer; font-weight:600;">Pošalji</button>
                <button type="button" onclick="closeContactModal()" style="flex:1; padding:12px; background:#6b7280; color:white; border:none; border-radius:6px; cursor:pointer; font-weight:600;">Odustani</button>
            </div>
        </form>
        <div id="contactMessage" style="margin-top:15px;"></div>
    </div>
</div>

<!-- Button za otvaranje kontakt forme - dodaj ga gdje želiš na kartici -->
<button onclick="openContactModal()" style="padding:12px 24px; background:#3b82f6; color:white; border:none; border-radius:8px; cursor:pointer; font-weight:600; margin:20px auto; display:block;">
    ✉️ Kontaktiraj me
</button>

<script>
const userId = <?php echo $user['id']; ?>; // Mora biti PHP varijabla iz template-a

function openContactModal() {
    document.getElementById('contactModal').style.display = 'flex';
}

function closeContactModal() {
    document.getElementById('contactModal').style.display = 'none';
    document.getElementById('contactForm').reset();
    document.getElementById('contactMessage').innerHTML = '';
}

document.getElementById('contactForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const data = {
        user_id: userId,
        sender_name: document.getElementById('senderName').value,
        sender_email: document.getElementById('senderEmail').value,
        message: document.getElementById('senderMessage').value
    };
    
    try {
        const response = await fetch('/api.php/user/contact', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        const msgDiv = document.getElementById('contactMessage');
        
        if (response.ok) {
            msgDiv.innerHTML = '<div style="background:#d1fae5; color:#065f46; padding:12px; border-radius:6px;">Poruka poslana! 🎉</div>';
            document.getElementById('contactForm').reset();
            setTimeout(closeContactModal, 2000);
        } else {
            msgDiv.innerHTML = '<div style="background:#fee2e2; color:#991b1b; padding:12px; border-radius:6px;">Greška pri slanju</div>';
        }
    } catch (error) {
        document.getElementById('contactMessage').innerHTML = '<div style="background:#fee2e2; color:#991b1b; padding:12px; border-radius:6px;">Greška pri povezivanju</div>';
    }
});
</script>
</body>
</html>