<?php
// generate-hash.php - Generator bcrypt hasha za lozinku

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    
    if (strlen($password) < 6) {
        $error = "Lozinka mora imati minimum 6 znakova!";
    } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $success = true;
    }
}
?>
<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hash Generator</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
        }
        h1 { color: #333; margin-bottom: 20px; }
        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; font-weight: 600; color: #555; }
        input {
            width: 100%;
            padding: 12px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            font-size: 15px;
        }
        input:focus { outline: none; border-color: #667eea; }
        button {
            width: 100%;
            padding: 14px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
        }
        button:hover { background: #5568d3; }
        .result {
            margin-top: 30px;
            padding: 20px;
            background: #f0fdf4;
            border: 2px solid #86efac;
            border-radius: 8px;
        }
        .hash-box {
            background: #1f2937;
            color: #10b981;
            padding: 15px;
            border-radius: 6px;
            font-family: monospace;
            word-break: break-all;
            margin: 15px 0;
            font-size: 13px;
        }
        .sql-box {
            background: #1e293b;
            color: #38bdf8;
            padding: 15px;
            border-radius: 6px;
            font-family: monospace;
            margin: 15px 0;
            font-size: 13px;
            white-space: pre-wrap;
        }
        .error {
            background: #fee2e2;
            color: #dc2626;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .warning {
            background: #fef3c7;
            color: #d97706;
            padding: 12px;
            border-radius: 8px;
            margin-top: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔐 Hash Generator za Admin Lozinku</h1>
        
        <?php if (isset($error)): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label>Nova lozinka za admina:</label>
                <input type="text" name="password" placeholder="Unesi novu lozinku" required>
            </div>
            <button type="submit">Generiraj Hash</button>
        </form>
        
        <?php if (isset($success)): ?>
            <div class="result">
                <h3 style="color: #059669; margin-bottom: 15px;">✅ Hash uspješno generiran!</h3>
                
                <p><strong>Lozinka:</strong> <?php echo htmlspecialchars($password); ?></p>
                
                <p style="margin-top: 15px;"><strong>Bcrypt Hash:</strong></p>
                <div class="hash-box"><?php echo htmlspecialchars($hash); ?></div>
                
                <p><strong>Kopiraj ovaj SQL u phpMyAdmin:</strong></p>
                <div class="sql-box">UPDATE admin_users 
SET password = '<?php echo htmlspecialchars($hash); ?>' 
WHERE username = 'admin';</div>
                
                <div class="warning">
                    ⚠️ <strong>Nakon što kopirate SQL:</strong><br>
                    1. Idi u phpMyAdmin<br>
                    2. Odaberi bazu taptapcp_cardbaza<br>
                    3. Klikni SQL tab<br>
                    4. Zalijep gore SQL<br>
                    5. Klikni "Go"<br>
                    6. <strong>OBRIŠI ovu datoteku (generate-hash.php)!</strong>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>