<!DOCTYPE html>
<html lang="hr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Analytics Login - TapTap Card</title>
  <style>
    * { 
      margin: 0; 
      padding: 0; 
      box-sizing: border-box; 
    }
    
    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 20px;
    }
    
    .login-container {
      background: white;
      padding: 40px;
      border-radius: 16px;
      box-shadow: 0 10px 40px rgba(0,0,0,0.2);
      width: 100%;
      max-width: 400px;
    }
    
    .logo {
      text-align: center;
      margin-bottom: 30px;
    }
    
    .logo h1 {
      font-size: 32px;
      color: #333;
      margin-bottom: 8px;
    }
    
    .logo p {
      color: #6b7280;
      font-size: 14px;
    }
    
    .form-group {
      margin-bottom: 20px;
    }
    
    label {
      display: block;
      margin-bottom: 8px;
      font-weight: 600;
      color: #374151;
      font-size: 14px;
    }
    
    input {
      width: 100%;
      padding: 14px;
      border: 2px solid #e5e7eb;
      border-radius: 10px;
      font-size: 15px;
      transition: all 0.3s;
      font-family: inherit;
    }
    
    input:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    .btn {
      width: 100%;
      padding: 16px;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      border-radius: 10px;
      font-size: 16px;
      font-weight: 600;
      cursor: pointer;
      transition: transform 0.2s, box-shadow 0.2s;
    }
    
    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    .btn:active {
      transform: translateY(0);
    }
    
    .btn:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
    }
    
    .error-message {
      background: #fee2e2;
      color: #dc2626;
      padding: 12px;
      border-radius: 8px;
      margin-bottom: 20px;
      display: none;
      font-size: 14px;
    }
    
    .error-message.show {
      display: block;
    }
    
    .footer {
      text-align: center;
      margin-top: 25px;
      padding-top: 20px;
      border-top: 1px solid #e5e7eb;
    }
    
    .footer a {
      color: #667eea;
      text-decoration: none;
      font-size: 14px;
      font-weight: 500;
    }
    
    .footer a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <div class="login-container">
    <div class="logo">
      <h1>📊 Analytics</h1>
      <p>Pristup statistici vaše vizitke</p>
    </div>
    
    <div id="errorMessage" class="error-message"></div>
    
    <form id="loginForm">
      <div class="form-group">
        <label for="username">Korisničko ime (slug)</label>
        <input 
          type="text" 
          id="username" 
          name="username" 
          placeholder="npr. zmadzar" 
          required
          autocomplete="username"
        >
      </div>
      
      <div class="form-group">
        <label for="password">Lozinka</label>
        <input 
          type="password" 
          id="password" 
          name="password" 
          placeholder="••••••••" 
          required
          autocomplete="current-password"
        >
      </div>
      
      <button type="submit" class="btn" id="loginBtn">
        Prijavi se
      </button>
    </form>
    
    <div class="footer">
      <a href="/">← Povratak na početnu</a>
    </div>
  </div>

  <script>
    const form = document.getElementById('loginForm');
    const errorMessage = document.getElementById('errorMessage');
    const loginBtn = document.getElementById('loginBtn');
    
    form.addEventListener('submit', async (e) => {
      e.preventDefault();
      
      const username = document.getElementById('username').value.trim();
      const password = document.getElementById('password').value;
      
      // Hide previous errors
      errorMessage.classList.remove('show');
      errorMessage.textContent = '';
      
      // Disable button
      loginBtn.disabled = true;
      loginBtn.textContent = 'Prijavljujem...';
      
      try {
        const response = await fetch('/api/<?php echo getPlatformSetting("analytics_slug", "analitika"); ?>', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            username: username,
            password: password
          })
        });
        
        const data = await response.json();
        
        if (response.ok && data.success) {
          // Redirect to analytics page
          window.location.href = data.redirect;
        } else {
          // Show error
          errorMessage.textContent = data.error || 'Pogrešni podaci za prijavu';
          errorMessage.classList.add('show');
          loginBtn.disabled = false;
          loginBtn.textContent = 'Prijavi se';
        }
      } catch (error) {
        errorMessage.textContent = 'Greška pri povezivanju. Pokušajte ponovo.';
        errorMessage.classList.add('show');
        loginBtn.disabled = false;
        loginBtn.textContent = 'Prijavi se';
      }
    });
  </script>
</body>
</html>